/* ParticleEngine */

#import <Cocoa/Cocoa.h>
#import <OpenGL/gl.h>
#import <OpenGL/glext.h>
#import <OpenGL/glu.h>
#import "BHMatrix.h"

#define MAX_PARTICLE 5000

typedef struct {
	// Next Particle
	void* next_particle;
	void* prev_particle;

	// Rendering info
	float x_pos;
	float y_pos;
	float z_pos;
	float width;
	float height;
	float life;

	float delta_x;
	float delta_y;
	float delta_z;
	float gravity;

	float minus_life;
} particle;


@interface ParticleEngine : NSObject
{
	particle element[MAX_PARTICLE];

	int used_particles;
	int free_particles;
	particle* used_list;
	particle* free_list;
}

- (id)init;
- (void)dealloc;

- (id)drawParticles;

- (id)addParticle :(float)x_input :(float)y_input :(float)z_input
	:(float)width :(float)height :(float)minus_life
	:(float)delta_x :(float)delta_y :(float)delta_z :(float)gravity;

- (id)updateParticleDB;
- (id)reset;

- (particle*)pullParticle;
- (id)returnParticle :(particle*)particle;

- (BOOL)activeParticles;

@end
